﻿# -*- coding: utf-8 -*-

'''
Torrent-tv.ru Playlist Downloader Plugin configuration file
'''
# Proxy settings.
# For example you can install tor browser and add in torrc SOCKSPort 9050
# proxies = {'http' : 'socks5://127.0.0.1:9050','https' : 'socks5://127.0.0.1:9050'}
# If your http-proxy need authentification - proxies = {'https' : 'https://user:password@ip:port'}
useproxy = False
proxies = {'http' : 'socks5://127.0.0.1:9050',
           'https' : 'socks5://127.0.0.1:9050'}

# Insert your Torrent-tv.ru playlist URL here
url=''

# TV Guide URL
tvgurl = 'http://1ttvapi.top/ttv.xmltv.xml.gz'

# Shift the TV Guide time to the specified number of hours
tvgshift = 0

# Download playlist every N minutes to prevent
# torrent-tv tracker forgetting us.
#
# 0 = disabled
updateevery = 0

# Channel logos mapping
logobase = 'http://1ttv.org/uploads/'
logomap = {
    u'0x0 Fireplace HD': logobase + 'H1VboxDJC7sE7x3nKXoYT0X5r4LIqD.png',
    u'0x0 Music HD': logobase + 'hFj4tnC5uqAgpod3doHnJGZxgZXaiP.png',
    u'1 HD': logobase + 'FtLnmUwjG18XJFEKYvLKjwUq1gwHVZ.png',
    u'1 MUSIC CHANNEL': logobase + '45atLSHAjViMISJinK8A0jQA34I0Fi.png',
    u'1 tv Georgia': logobase + 'geM35mbIzNqzz3LBvxnViw2EviT2BW.png',
    u'1+1': logobase + 'omm2Xc8xSVIT6Od6ca4QqMrEXw3jaK.png',
    u'1+1 International': logobase + '6fImIbJqJsF3pJQi2UuYRwtRyHMeaB.png',
    u'100% News': logobase + '9yEWvPmTcFS8lyQ5NjJ7vbYOa3bx1W.png',
    u'112 Украина': logobase + '0AUjU7DOzZcpizC4UR19vDZqqthSe0.png',
    u'112 Украина HD': logobase + '0AUjU7DOzZcpizC4UR19vDZqqthSe0.png',
    u'12 Канал (Омск)': logobase + 'ejWH5qVf8XAWkc3HLQYTmEpYchtaIS.png',
    u'2 канал (Израиль)': logobase + 'CSw0eG13VxmrfPXWwUOHyerOhd53UC.png',
    u'2+2': logobase + 'XHXBC3ghvhh100BNXylSgJLx5FVQgD.png',
    u'24 Украина': logobase + 'XfKEdfsy4S1zbE8n2tB1tNNe9IkrRP.png',
    u'24 Украина HD !': logobase + 'fndLsRJ2T4AFEYqVxMkvz8teE2aTuw.png',
    u'26 Регион HD (Ставрополь)': logobase + 'WdXmMmnehWo0vdzVwA4z1tGgRjFTWt.png',
    u'2x2': logobase + 'hTpJUV15GSTxZ5kJQGLcn42kCzKyEH.png',
    u'2x2 (+2)': logobase + 'ZPOhZle6vrDaulo2KMmyrCkkkLn7Ci.png',
    u'360 градусов': logobase + 'K4tiqb5ajIgmxqh8X5moJuDjN7q5hx.png',
    u'360 градусов HD': logobase + 'K4tiqb5ajIgmxqh8X5moJuDjN7q5hx.png',
    u'360 Новости HD': logobase + 'K7RGdQQaKY78l29J4Xfgk4F0t9a2jq.png',
    u'365 Дней': logobase + '0IZrVwoxtmjtgnWu5Dj4Hb8FRc8NIX.png',
    u'41 канал Домашний (+2)': logobase + '6vBXDKono9On9ND4WG49IeaXzdjWcX.png',
    u'43 Канал HD (Туапсе)': logobase + '1mNoU1QXmcmK48eVTlnADtsEBmA2sN.png',
    u'47 канал': logobase + '8aHwrc5KVFI4FXwgPbBf5vjBSIQ52B.png',
    u'49 канал (Новосибирск)': logobase + 'liRZcIcNbzQTngm8CIkcnw7gLJfeIJ.png',
    u'4Fun TV': logobase + 'MBRDVkacgvAn0zw4ceuI1ji9LxJFsb.png',
    u'5 канал (Киргизия)': logobase + 'ftgWX6P9yWch8a2fF7qH7QdmhtWPu8.png',
    u'5 канал (Украина)': logobase + '9La0uS6S8rMKr0BOh6vSCQLNiCqN7N.png',
    u'66 канал (Израиль)': logobase + 'ZNDGDdjbJMIB3owCIKosKGsUFe2En3.png',
    u'78 канал': logobase + 'ZloJoTx0yurBDfEtB6V91vRuF8mxB4.png',
    u'78 канал HD': logobase + 'ZloJoTx0yurBDfEtB6V91vRuF8mxB4.png',
    u'7ТВ': logobase + 'vNvqlbSnA9yjRCEdcGV773QxysaOxm.png',
    u'8 канал': logobase + 'wKPUJjcpZIfI5zBSZwNayOlv63zRNV.png',
    u'8 канал (Красноярск)': logobase + 'wKPUJjcpZIfI5zBSZwNayOlv63zRNV.png',
    u'9 волна': logobase + '8zDeTSBhsmJDbXo9dxHA1c9mDOP9sP.png',
    u'9 канал (Израиль)': logobase + 'dsi2SD7Pmq3sxxaNPpRAUgKmxXh4s6.png',
    u'9 канал (Рязань)': logobase + 'bO1hIXjoA3KytchKgshG1Bhzcz2DNT.png',
    u'Abu Dhabi TV HD': logobase + 'ejWH5qVf8XAWkc3HLQYTmEpYchtaIS.png',
    u'Al Jazeera English': logobase + '5ZfDU3kFx7mh5ntH0QZfagkjIWbZ4C.png',
    u'Al Rayyan 2 HD': logobase + 'ejWH5qVf8XAWkc3HLQYTmEpYchtaIS.png',
    u'Almaty HD': logobase + 'DKYJ9oBuRE2JmxrZNo4i4vM9s8dsUb.png',
    u'AMC': logobase + 'rozrC8ZPYA1YGajyow35doeVcaQzpa.png',
    u'Amedia 1': logobase + 'jT3vAEOG5jTd2t8GcC797Bw5W0kSl9.png',
    u'Amedia 2': logobase + 'fAvxTQbWu0DAcMkqej0m73KohAcQJw.png',
    u'Amedia Hit': logobase + 'HdnTfcZCgP7Odm1cOKNq9j4yJDRiFP.png',
    u'Amedia Hit HD': logobase + 'HdnTfcZCgP7Odm1cOKNq9j4yJDRiFP.png',
    u'Amedia Premium': logobase + 'ornzQpk6WCW6xk0lyBhlwqH8u2QyU7.png',
    u'Amedia Premium HD': logobase + 'ornzQpk6WCW6xk0lyBhlwqH8u2QyU7.png',
    u'Ani': logobase + 'vui1cRrE05CZv1N9Qb20jJ6mTFOJue.png',
    u'Animal Family HD': logobase + '6Xrlt9W9PBeF99h1ayRh8zteAheFUQ.png',
    u'Animal Planet': logobase + '45.png',
    u'Animal Planet HD': logobase + '9HZGan5rQItVQOfnB91FGqyJXjoqYV.png',
    u'Anyday 3D': logobase + 'Q9gPrtyM73PzW5Jlf0pXnjCJcT0Tq7.png',
    u'Anyday HD': logobase + 'nZ0Aa5bcpThFFTGvBUfW65GTgVoH6c.png',
    u'Ararat TV': logobase + 'HdJCAim5FV0bpwYQ3Fam5yxoMzFxAe.png',
    u'Arirang TV': logobase + 'ejWH5qVf8XAWkc3HLQYTmEpYchtaIS.png',
    u'Armenia TV Satellite': logobase + 'M4UAMT6cEyL3zuim9fzy38vZRkIfKq.png',
    u'Art-108 HD': logobase + 'RXU5Txc5ki40dg6pJUleIMIabCcltD.png',
    u'Astana TV': logobase + 'R09FzjK0PWCE06kTL9obz4RpJ9SUl5.png',
    u'ATR': logobase + 'uggqxQxxDTuz1P1mY4PZdlRcAKow3F.png',
    u'ATV': logobase + 'ejWH5qVf8XAWkc3HLQYTmEpYchtaIS.png',
    u'ATV Azerbaycan': logobase + 'yx7GzFSH3BlxYYa0Nuq4eiVRqxZSa5.png',
    u'Aurora HD': logobase + 'HYtru2e2Sh6VrZsnNxdTyNfO8m9eoM.png',
    u'Az TV': logobase + 'FB2qxgNm8xTU6YiR2fY1jH4PIRR2SF.png',
    u'Babestation': logobase + 'DbvHMminWOobAbD3IliRECsG8RH6uL.png',
    u'Baby TV !': logobase + 'aE2CDNS2w6p5LA4OThfOWOzYT7jQno.png',
    u'BBC World News': logobase + '8cSYWwvq6BAzcGDjJODvCGQYGJ2c4S.png',
    u'Bloomberg': logobase + 'OTsoNZRT8xjXz5nnTICPCQRvNLjBal.png',
    u'Bollywood HD': logobase + 'HXzWxtMxmXkrpgr88Kh8Z1A8F6o5dK.png',
    u'BOLT HD': logobase + 'EEZrUgR0IgyOp97DI8sGPT78J40Doq.png',
    u'Boomerang': logobase + 'tsP2U3zkp5o8B0TD6luRLg0leS9FvM.png',
    u'Boutique TV': logobase + 'bDSWVUfAEYN9VS25roxW52xO1pj6qp.png',
    u'Brazzers TV': logobase + 'VPCmFsMfpnB0pg9VBzvUG5TkRcHTsR.png',
    u'Brazzers TV Europe': logobase + 'OmVBp3Kz4Lx722dq2e1OxE26QSxrDA.png',
    u'Bridge HD': logobase + 'P7JEo7cGv1dtk6X69SkfEQeiVrQvXj.png',
    u'Bridge TV': logobase + 'dPhBiaViIznwjeWU3pTbIXFmS3iJkU.png',
    u'Bridge TV Classic': logobase + 'NCuKRKNU2rwc8DkpF555fINSz5xaIc.png',
    u'Bridge TV Dance': logobase + 'ofmgiZlRmwOZtTaYtUtfErZS3ODDDM.png',
    u'Brodilo TV HD': logobase + '0pLPWiGqZjDe2O4vbPd8QL0qGsA9lq.png',
    u'BT Sport 1': logobase + 'RNwudSF1Lys88WmIXhiS43g2urfknl.png',
    u'Business': logobase + 'wvwXc2x8Bjev90GD6LO6t7TL2aKW1h.png',
    u'C Music TV HD': logobase + 'YhtkJhsV8NKwm4FGWhQZDmYcW0TYQS.png',
    u'Canal 3': logobase + 'rb39jMz38xLuXKGCuWD2GcHHMEzfX1.png',
    u'Candy HD': logobase + 'YW8BJnImniuR7l1U85Khw31mX2XO0S.png',
    u'Candyman HD': logobase + '6fgWPM2UHUiHic7UVLG8YCVq5bC7uw.png',
    u'Cartoon Network': logobase + 'NTNQLLri3Hh9iqYjW7VEkFYJsTLjk9.png',
    u'CBC Sport HD': logobase + 'ejWH5qVf8XAWkc3HLQYTmEpYchtaIS.png',
    u'CBC TV': logobase + 'ejWH5qVf8XAWkc3HLQYTmEpYchtaIS.png',
    u'CBS Reality': logobase + 'QbWaD2vNgLRLY0Hsccg3nf9azAXRld.png',
    u'CCTV 4': logobase + 'PsrMNDhKrEgCJA5lAR9UUtBlOI4uJg.png',
    u'CentoXCento TV': logobase + 'dPuPlqJtkLMRy7NmOhyHDfL0PJqYj4.png',
    u'CGTN': logobase + 'TyWVFvKwV3lOYYXWVJSj8HMu5AodJr.png',
    u'CGTN Documentary': logobase + 'dqoArqO8dd09vzsSSQPqLUj5wM9O9M.png',
    u'CGTN Русский': logobase + 'DcaE92lKRSDFBPlYUnsNRauFLbotKu.png',
    u'Cinema': logobase + 'beyfqyeacrFG0PrOeKUQhzQ4bV6Q5d.png',
    u'CNN International': logobase + 'lIwbRbM3ve4ixhFXp75Oap9nzcO71G.png',
    u'Da Vinci Learning': logobase + 'Yl6p1IDDkZxxiUa3p2JxI66mIlOPns.png',
    u'Deutsche Welle': logobase + 'RnqBDfde1HP4OkZhXWlKB1xkHi6Io9.png',
    u'Diema Sport 2': logobase + '4xUpzBxK0sL6Hc9KQADA1LhmFbE9Yi.png',
    u'Discovery Channel': logobase + 'oKx1ImWVRT3AK3DHYWUVc71JZUkwu5.png',
    u'Discovery Channel HD': logobase + 'SmWnYlOvkJn8GzttT2UY0vmo8PYfMg.png',
    u'Discovery Science': logobase + 'GAaO3EfDwMuHAIelG4gYW6TDEYbLnS.png',
    u'Discovery Science HD': logobase + '5rlWsKfvt9jYnUht7vXqEqA47Y05wh.png',
    u'Discovery World !': logobase + 'dMUIABPd7wmzLHryJ0IjVKRvWSZXkS.png',
    u'Disney Channel': logobase + 'JxEjTeXwExjnxutQGKJBmMI85tpNqK.png',
    u'DocuBox HD': logobase + '4ZjuKuTHFCuXqKkEmKYGcBFe6UK5z4.png',
    u'Dog TV': logobase + 'NblfllG2mrqX3Zrb36rv7hLUe2sG1R.png',
    u'DREAM PORN HD': logobase + 'rEdYcZis6CYk8QAFJzJRQQE1NPoZGj.png',
    u'DTX': logobase + 'bx7MosYUikfuwwIOzx2elT6Dh7h50I.png',
    u'DTX HD': logobase + 'bx7MosYUikfuwwIOzx2elT6Dh7h50I.png',
    u'Dusk TV': logobase + '5j0MFmxPLBN36rJR2yYxgnOOHa23gh.png',
    u'English Club TV': logobase + 'Hf5RUQ91cEGtHoaK3GK6VIZlJ8Leql.png',
    u'Enter Film': logobase + '8FPA5SCEIj35fBO8yrULnefW4NzIzk.png',
    u'Epoque': logobase + 'eULbHv3DyublWF2rAhw38DV63cV3V9.png',
    u'EPOQUЕ HD': logobase + 'EKfkYWRSkYiN76MxCZCjawxewjBOYY.png',
    u'Eska Best Music TV HD': logobase + 'wI3e672FQZpD8yr8aIV8Q2fL15zENv.png',
    u'Eska OldsCool TV HD': logobase + '7LW3s6C3D3yeciqTY0CKXpEmL3Tb3w.png',
    u'Eska Party TV HD': logobase + 'MaX9is65hlDpRDwgOikGE2RqMRxn8G.png',
    u'Eska Rock TV HD': logobase + 'VU2POxFhYCM4XhFAtOp8Y4sdlbu32M.png',
    u'Eska Wawa TV HD': logobase + 'r9d697qox4MFgypnVqeILYWKcfbwNc.png',
    u'ETV': logobase + 'EXXEf0i7yGRDFttKSwBq4CLoGiuxbW.png',
    u'ETV2': logobase + 'dR4fj3bOJ4PAqBEKskc9yLNj0unwAD.png',
    u'EuroNews': logobase + 'Vb3fP5gUK0q40WuzYeUhMT7RQmDg27.png',
    u'Europa Plus TV': logobase + 'PkatgpdmA4ArsgSG5shu0ZCQQ5RgMx.png',
    u'Eurosport 1': logobase + 'QA9jgUaQRrE4vMno04eM3aUrklXOce.png',
    u'Eurosport 1 HD': logobase + 'DpFTzUEA3y67Z6ObTPF4xH0XLNRAZm.png',
    u'Eurosport 2': logobase + 'qYbdkVFDkhGqTAjXlRtIj2Fg45bmrm.png',
    u'Eurosport 2 HD': logobase + '0mo5WOW3xn7FmcIRM9PMZxb2Zgad86.png',
    u'EvilAngel': logobase + 'FufZ2heFswzvAbRkTQZs8UJBYGsxuG.png',
    u'EWTN UK and Ireland': logobase + 'maP6bdwOGv77xHPvRnKBHww9cmG2oV.png',
    u'Extreme Sports': logobase + '21FhIqWK82JDPNuLTEIC9hSO2EHfks.png',
    u'Extreme Sports (резерв)': logobase + 'F4fGoW5QeUXRJnNnfOnhY3ZejkVyPn.png',
    u'FAP TV 2': logobase + 'YVmUBY8cBPO8IoL4djlyeKCDbs6f0p.png',
    u'FAP TV 2 HD': logobase + 'KqVXT8GPTPuPEM87hZSqDwajqcBBgY.png',
    u'FAP TV 3': logobase + 'S5gXPPcF53lFHQ3kgJofKMQudRQKPt.png',
    u'FAP TV 4': logobase + 'xv1QyBV2OkaDbZ1ebRB2FWwfw40BR5.png',
    u'FAP TV Amateur': logobase + 'LGfemDTp3Z3mvhn1aKSGVvtlNu5zMF.png',
    u'FAP TV Anal': logobase + '1PVgf85c4DjIsiWEikpEHDV1j1m6ph.png',
    u'FAP TV BBW': logobase + 'PHnwbskpP4oixpMjlJKgGvTAajXFSg.png',
    u'FAP TV Compilation': logobase + 'FXT4PI3HHWIGlk49jRpHyGQBTTVbmt.png',
    u'FAP TV Gay': logobase + 'vJB3tfzXuDX8R7eLXV63tCFgxnOgP1.png',
    u'FAP TV Legal Porno': logobase + 'QMv8xcYgTaW9108ymib6XyWXRMI7dn.png',
    u'FAP TV Lesbian': logobase + 'M3LLmt76GGyLBhpAEnRtn368pAeGH3.png',
    u'FAP TV Older': logobase + 'G1L5Qh2QVnSu6zEVua6KOI4hxtUfcn.png',
    u'FAP TV Parody': logobase + 'mu4NIjgq7Xu5nt32zTSxGvBOfk90xt.png',
    u'FAP TV Pissing': logobase + '3QJ9sSAI90ALizvl1B2sbt8WxIVLSu.png',
    u'FAP TV Shemale': logobase + 'd5ulbooZicKw3aMLwn2Ho0yD9c46T2.png',
    u'FAP TV Teaching': logobase + '3MzvfwDLSX8zUmmuO7TpS8O2iD03Tj.png',
    u'FAP TV Teens': logobase + '7Z9gyzosm1oUC82aFfA3mBG9YAjOrS.png',
    u'FAP TV Trans': logobase + '05P2Z8lWWIgaEmvWcTRO1R9F0lMPZL.png',
    u'Fashion One HD': logobase + 'iPs2ptiBXm8h0KSnRmyqu45texHNig.png',
    u'Fashion TV': logobase + 'PSjqabjhYIBqcS8hUA8WNrZEjV4zZY.png',
    u'Fashion TV HD': logobase + 'z6q34MCsDCntK8jbJXp4pBQiPlIiNx.png',
    u'FILMUADRAMA': logobase + 'ejWH5qVf8XAWkc3HLQYTmEpYchtaIS.png',
    u'FilmUADrama HD': logobase + 'fWGkWZarY98h18LXSQwHmSAZNXhZW4.png',
    u'Fine Living': logobase + '22I1fK1aMCUgeYUCV0K3vwmlJKELZD.png',
    u'Fitcult TV': logobase + 'XIwNf2TL3xUPnLD0L7Y5Q1FUwwpcSp.png',
    u'Food Network': logobase + 'W68LEGlOOMPtN0qoGXvdkWhHBjKet6.png',
    u'Fox': logobase + 'XGC77wQNeEyaJ2z2mDipyIPsoF0xc1.png',
    u'Fox HD': logobase + 'Pl8S60EJ52htHxi1gAw1SS1y8i1p3z.png',
    u'Fox Life': logobase + 'rkksGUl3DstQSEyT26Q07hNCEwyNnd.png',
    u'Fox Life HD': logobase + 'Vou521VpOGAGqhp4HUfiG7BSbKNSk6.png',
    u'France 24': logobase + 'pViXgcMjLnB5WyOoQJ7sBxhHo5fTSB.png',
    u'Galaxy TV': logobase + 'pU2NsRP9CVtEgQuDTi9jcTYV8iAD4a.png',
    u'Gamanoid HD': logobase + 'DxEQkipHmJjSY0wHGKHDV6eAZKiwoG.png',
    u'Game Show': logobase + 'Uc9sBHj0DAYzfXMZmdxeriCBZvUpeb.png',
    u'GAME SHOW HD': logobase + 'x8rAmyXyw8Alq0OKwV9d8iB56lVxRn.png',
    u'Ginger HD': logobase + 'eW7CqWW2bppbpKzhNctyElyv5Nzs30.png',
    u'Glazella 3D': logobase + '7EM3eHww2EvOf9jgeFPdZrsQwO8Fz7.png',
    u'Glazella HD': logobase + '7EM3eHww2EvOf9jgeFPdZrsQwO8Fz7.png',
    u'GlobalStar TV': logobase + 'Y4kNxgbAnPGCt753P73NzCIbcNz5lD.png',
    u'Gulli Girl': logobase + '2IynBdmw3mmdXt01r8DXKxeor7STnw.png',
    u'H2 HD !': logobase + 'U7FUILutKUn8pF2W5JdMGMvcfrKIIb.png',
    u'HardLife TV': logobase + 'fHPc5oaRdIzKpHTqBFnHA4O2LVf91D.png',
    u'HD Life': logobase + 'jUteUS0xRGdvLyBVqNjowEUDkOjT0t.png',
    u'HD Media': logobase + 'woAI3zcytfbyiX0LBRToKzErJNy1qF.png',
    u'HD Media 3D': logobase + 'takNty6pirY7TeCRPX5VyUW1mZHHxI.png',
    u'History Channel': logobase + '9cVifexiWW0qWDhhpnLNVydoZkeRqZ.png',
    u'History Channel HD': logobase + 'VFgU260pmiIyPxCzD3f8R7Yc6DXClH.png',
    u'HiT Music Channel': logobase + 'n7tghbIGAAh8cyWe7Li0E2iNEJSqkl.png',
    u'Hit TV': logobase + 'FnCnW1vmvm8gjAwMGXe2Q8qtN1C3zy.png',
    u'HIТV HD': logobase + 'rx6sjyAVpjkYDNPEwX5XksWyxx5mVg.png',
    u'Hustler HD': logobase + 'LBz8ia8AASewVuLjMs5v4MDiVYfsJO.png',
    u'Hustler TV': logobase + 'wgAR4TI1xdd2LAtnbkpvFAfnnn5Uru.png',
    u'i24 news (Израиль)': logobase + 'eIIDTFtWAOPOT8x5p5ICSucpe8JBZo.png',
    u'Ictimai TV': logobase + 'ejWH5qVf8XAWkc3HLQYTmEpYchtaIS.png',
    u'ICTV': logobase + 'YuNtYxhj9vqgTU9kVuz9imhqviY4PZ.png',
    u'ID Xtra': logobase + 'fq3ovkZeu4R4YVYt1VMZN1NU7mMrH9.png',
    u'Idman TV': logobase + 'UhhUZdtM7FjDFbmoleWalj7tp6nj5o.png',
    u'Iland': logobase + 'S2eR34Z8l9ne1lteBOLvknOq64jMJN.png',
    u'InterAz': logobase + 'rdntbmpYEYtyRbW3nGa1FUNZPXF53O.png',
    u'Islam Channel': logobase + 'XqP875iZVDQXcyNB4AnAEZ4n3PX9xs.png',
    u'Jasmin TV': logobase + 'MBRUFcRx5wtHLZmgahvcGdXB2ERdst.png',
    u'JimJam': logobase + 'BPDFCK5SQF3mXu5MsDNSdtvz4Gjawo.png',
    u'JuCe TV HD': logobase + 'oDJZW3oCgEFhE5Cvrm7YfcS63iag5x.png',
    u'KBS World': logobase + '0bbrB0JSsAxtzY3suHEeph2V6oJGng.png',
    u'KBS World HD': logobase + 'ejWH5qVf8XAWkc3HLQYTmEpYchtaIS.png',
    u'KroneHIT TV HD': logobase + 'dq6m0UE9ffgAbXNt49qDlIAr7T8lud.png',
    u'Lale': logobase + '99AZ5VwFy9yZrgsdZ6kIxcoYqwSyUH.png',
    u'Leomax': logobase + 'HGm0W3LbxRPeRcgEdYuuBEKp1zJ104.png',
    u'Lider TV': logobase + 'LByLhdeQ30Ln5pSZRYSpoLpXQS5Ytr.png',
    u'LTV World': logobase + 'ejWH5qVf8XAWkc3HLQYTmEpYchtaIS.png',
    u'Lviv TV': logobase + 'VMl4S9yd5IYFAVFaR8XG6KEm5pgVu4.png',
    u'Maxxi-TV': logobase + 'uqyYr07PPk2OuEdnNrbkMHVlGZCJp5.png',
    u'MCM Top': logobase + 'b4SLIxXFbKUErZxBXfGoo6eQN5Mu38.png',
    u'Mezzo': logobase + 'GUzJ4cyK50ZahOSIx6tTbwGLJiUnSA.png',
    u'Mezzo Live HD': logobase + 'lGOtRiUoGyJUMCtAtUwevBerpQORD4.png',
    u'MGM HD': logobase + 'o4K0lgc2D1GkuFwMC3Cdg1uK6fMrG4.png',
    u'Mi Lady': logobase + 'Fd556PD2ffD6zdVUiX0dvVfBJavBNd.png',
    u'Moldova 1': logobase + 'OdWQq0RFoU0GODPHsR94zpTnyFoUX2.png',
    u'Moldova 2': logobase + 'V0jtpwewWSjbPJS7KCkIbDXkQA5ne8.png',
    u'MTV AM HD': logobase + 'tctwS97YUw7YyfwmeST8rXLHfrQC0v.png',
    u'MTV Dance': logobase + 'ZXKNRw6Ai8u4lY0wxeycQwj2dIkm66.png',
    u'MTV Hits': logobase + 'iLJhuLh9kFLQkG4ERvLGSjSgMfNiM4.png',
    u'MTV Live HD': logobase + 'WjyYXtYHhG5COxGab7luHb1bmvAioA.png',
    u'MTV Rocks': logobase + 'SEwn7rL2FxPcf5Ol9KRKedIwXlpsAP.png',
    u'MTV Россия': logobase + 'P5ijp2sRQsKVZkOJwjdqIVgYdJzhpZ.png',
    u'MTV Россия HD': logobase + 'YOE9yEg2KwmItjHwMHcQDVvIMsfOTg.png',
    u'Music Box RU': logobase + 'zaHCW7nPCyGRnqHDkenCIXo7d6vR7v.png',
    u'Music Box TV': logobase + 'fvt4pris0lwnVhSyUrh8QlyzWBhbgz.png',
    u'Music Box UA': logobase + '8T7Rnct8q2VHhRm0BcGFxCjxuYEArc.png',
    u"Music Choice 90's": logobase + 'QN9CRHnBlwKPK555QLsUWwoyGEJmox.png',
    u'My Zen TV HD': logobase + 'JkOLtB3RVvI3d2oOC2RSE2ZynIVltv.png',
    u'N24 Austria': logobase + 'aQjAnNNoEEtgaFuBFQkBSfh8A5kwlX.png',
    u'N4 TV': logobase + 'R1NDSrUKnB1RoT8iv1okSe2xY39W4J.png',
    u'Nat Geo Wild': logobase + 'ciHIDUuHEnkEuPghbcqkDQx4vadle3.png',
    u'Nat Geo Wild HD': logobase + 'YYa1wyNA9prFK1APZ2ZSHGirPpm8kY.png',
    u'National Geographic': logobase + 'i6STSw6Hg1wWP18yBAOyKoKpSMeKLu.png',
    u'National Geographic HD': logobase + 'hK1waimMq9eAp0ugM19moSoQvUeve5.png',
    u'NEBISET TV': logobase + 'bugOHtRHyF9Nx5ba50Eyf547mn8kS1.png',
    u'News Network': logobase + 'puoOIFeHu3ojMldKVG7VVObJji589p.png',
    u'News One': logobase + 'SnaQqBa1YMS2b8b8EGdZSMCConLbDS.png',
    u'News One HD': logobase + 'jlgF3yZBnmiBKmYCa20SmajQmPqqYQ.png',
    u'NHK World TV': logobase + 'JJ8Sh9c7zA3PaXlK1ZaNjy3GgWQFh2.png',
    u'Nick Jr.': logobase + 'D87kJ3fIWIm5wKi5qxm24nbuPQv0U8.png',
    u'Nickelodeon': logobase + 'j66xpaZbfiYIgQxv76QAPckPVjmLNs.png',
    u'Nickelodeon HD': logobase + 'CFYx7Bd1aDSgkqjMLLQjFE6xe3u1E0.png',
    u'NRJ Hits HD': logobase + 'lSwvcnY5XfGEwyrKSvygH73fcYDZKI.png',
    u'NTD TV': logobase + 'iy4LZ8PlkstKJ2uuyIELVMuCSz5yEy.png',
    u'Nuart TV': logobase + 'aqMIuUixqLQYmJITPnOGtFkRPuTqKa.png',
    u'NUART TV HD': logobase + '1Ivzqb3yf7X4nk8zQNkCZmW0vthj6g.png',
    u'O-la-la': logobase + '7ddvb8Tivq7yuEgffrKildHi2BQcCE.png',
    u'O-TV': logobase + 'UlIt4rE3FZs7IQmPN3tsGS6fqY5F1D.png',
    u'Ocean-TV': logobase + 'cvBAngU16nJU1bEzxAEcMPiPvf7fVT.png',
    u'Ocko Expres': logobase + 'xh9xvE50KtXueT6WGZt7QBWZk7y0uL.png',
    u'Ocko Gold': logobase + 'ZfRkKa5NkLQ0rxDI0Z4XHqTsJkQs2Y.png',
    u'Ocko TV': logobase + 'GRn2qo7rOMBDzPPSBdF1NaWsLPEtbd.png',
    u'Outdoor Channel': logobase + 'SuxFoocUmay5G8jtfJaHL1yIbAT5Hr.png',
    u'Outdoor Channel HD': logobase + 'SuxFoocUmay5G8jtfJaHL1yIbAT5Hr.png',
    u'Ovideo.Ru HD': logobase + 'DecuiVbBOWvLVg2VX3MXmegwxCdowF.png',
    u'PanArmenian': logobase + 'Goi0hXa9CeThenpkvfPq7E961TMUAT.png',
    u'Paramount Channel': logobase + 'Iyzjhb5BBRKfvEZdBwNJ785jzroODU.png',
    u'Paramount Comedy': logobase + '5EtvAWXB7VK1Yw82yvO28sY28dU4ZC.png',
    u'Paramount Comedy HD': logobase + 'm8YTKk5S5vVQ1rdmi1lsgTCOQH6lY7.png',
    u'PassionXXX': logobase + 'U2oO3j1eda31nrTwHqaQ8psrLfH5CD.png',
    u'Phoenix CNE': logobase + '4A3PI1xIjIeECNSMDDvOfwXd5n2sso.png',
    u'Phoenix Marie TV': logobase + 'mC9hfoTbTEXlNXEVFrJvXaj78QGUhA.png',
    u'Pink O TV': logobase + 'aI99kH6bHY5Qt2ph4W1Nh0wxdzd1p8.png',
    u'Playboy TV': logobase + 'lIWBxmt5GDl9tg4KsQNtA0CuZWdOHH.png',
    u'Polonia 1': logobase + '3fzUyCBgUoJ6zqc92KSXh9g9utJEuO.png',
    u'Pro Все': logobase + 'OavKhOpBMn27qPDKJXXm5rgATgovgn.png',
    u'Publika TV': logobase + 'hPRLrpD7ukXhAbmEYnLIJu3naFWWrX.png',
    u'QTV': logobase + 'zmh1xStjBZGJ6U5g3xLoemD2oT3w3h.png',
    u'Rai 1': logobase + 'jTchRtiY0FJ91k1YQxBVHgi0rJ2fJX.png',
    u'Rai 2': logobase + 'NwtqcjZNlE2S71D47e4VQua263z0yw.png',
    u'Rai 3': logobase + 'IpAZDnIoXaiRiteKWVWNRIVFIlf8Sy.png',
    u'Rai News 24': logobase + 'CXDYq1FWPBJgCMUXcOmmfSA4hff9qe.png',
    u'RaiNews 24': logobase + 'lSQGWWO5EgBMQYSzctZ6551jifnl8z.png',
    u'Real Madrid TV': logobase + 'KfoLG7goywcRhMMCc3sO8IVwhuATLp.png',
    u'Redlight HD': logobase + '5tFZcJtKAZRbXtKGDuLe8FZ3lK9LI5.png',
    u'Reshet (Israel)': logobase + 'Phkr2nC2VEYdqNjV4wDZ1cKRvm0IfM.png',
    u'Retro Music TV': logobase + 'zVS9G1oine56udlAK30gNut16iJ9Ft.png',
    u'Revelation TV': logobase + 'gK8K5dIwNW8YqrGZCilO42UX0NF03i.png',
    u'RMC TV': logobase + '3CiAgachWg7ohgoU1Gilcm73hXhT41.png',
    u'RTG HD': logobase + 'g4MDyw0yqXWkIar8eH0cgCz4xhiKON.png',
    u'RTG TV': logobase + 'IeaOjwR6Q9eJjGZr0LYk2tpchM3ITZ.png',
    u'RTL': logobase + 'Ho3hZD4j3ZPbSrbPPw55sUmty44Lqy.png',
    u'RU TV': logobase + '161.png',
    u'RU TV HD': logobase + 'YiMEY6LT8ePoGhXJ7lKz7Os4hY3DOP.png',
    u'Rusong TV': logobase + '186WxZMn3PGQyMlWsItM9JkSS4Tt29.png',
    u'Russia Today': logobase + 'rL14fwCe8q10mKTchOwLkfwQVki9XK.png',
    u'Russia Today Arabic': logobase + 'OPbYfpQc4ShP8JmgPeiavUroY98H8L.png',
    u'Russia Today Doc HD': logobase + 'b8QePfFi6zsCDS7hfTeFWES5UN4SAk.png',
    u'Russia Today Doc.': logobase + 'VOYx5PIhDPrWiZIcCYpm1xrDSQZnsN.png',
    u'Russia Today Espanol': logobase + 'zkPwjfFbktNO8EYDaHlYhwAeT88dmY.png',
    u'Russia Today HD': logobase + 'rL14fwCe8q10mKTchOwLkfwQVki9XK.png',
    u'Russian Music Box HD': logobase + 'CbPggS9SpKMrgFW5myDvhLEFvm0hwp.png',
    u'SAT.1': logobase + 'eptvXkOPV7lRukQOEmjSvO0yv5aU29.png',
    u'Satisfaction HD': logobase + 'isdNgbfGENuaDPSMzsz8WMjBzc1rah.png',
    u'SCT': logobase + 'bDRN0guXHaNHruxtyFkpKYz8J09Xj3.png',
    u'SET': logobase + 'tKzOKIcOQYrFl1VL8B0QqERFXCAYfU.png',
    u'SET HD': logobase + 'sX1unYoKj8JR7m8lbtkmPCClRrjAZ9.png',
    u'Sextosenso': logobase + 'HXMvFMLO9weHUcolVmmMKpz98T0K4K.png',
    u'SGDF 24': logobase + 'zgX83hMJYukAhttCXvDa12o959Mt82.png',
    u'Shop and Show': logobase + '7NlIUTEOE8fvLFVxXCRqpYzhuuSMmB.png',
    u'Shop24': logobase + 'bCuxLyvoTk8l5cBRSyKFXjWjYucvlu.png',
    u'Shopping Live': logobase + 'HVwxC489SYFr8Ttqs1he9RZjEmJjPn.png',
    u'Shopping TV': logobase + 'Yhipu86vXMGf0hxCTXLezpGpcUbibW.png',
    u'SHOW MAX': logobase + 'BwzG83cJD6do7yT2lUE1QKKWlhLPxh.png',
    u'Silence TV HD': logobase + 'DoGC3WJCbY8YaqqDRNKozHipJbcv4w.png',
    u'Sony Sci-Fi': logobase + 'zLWEgf9BbxBr1TR2Qj2NxVQBuPecEP.png',
    u'Sony Turbo': logobase + 'CaPjVaQrpyN138TarQ7CYBqBOz0ZF7.png',
    u'Space TV': logobase + '5WT7hzZe3qEzKV1Diqwyd37xS671BG.png',
    u'Spike': logobase + 'KPNj0b4rZBtEB50yasdM72Th7UqrKm.png',
    u'Stingray iConcerts HD': logobase + 'E5ATzWWTj9YEisp6P9Vhm6GaYzZb2N.png',
    u'STV': logobase + 'DbKEKL5gUOFHiruYRjY2H9gTLOV5mu.png',
    u'Super Tennis HD': logobase + 'mjQW91VJdjIEhADvOO2s6OiKNeUdUK.png',
    u'Super TV': logobase + 'iRrgl4xiCvibdxWfiQcVUWuYCYCI9K.png',
    u'TBN Europe': logobase + 'bZT2NYEtReHVOSFTcW8xuDTVDvcoUn.png',
    u'Tele 5': logobase + 'BahbW0uBxpVOHayoLrr6uFcaBsiYSc.png',
    u'Tele Vsesvit': logobase + 'ejWH5qVf8XAWkc3HLQYTmEpYchtaIS.png',
    u'TelePace HD': logobase + 'ejWH5qVf8XAWkc3HLQYTmEpYchtaIS.png',
    u'Telesur': logobase + 'ejWH5qVf8XAWkc3HLQYTmEpYchtaIS.png',
    u'Teletravel HD': logobase + '4ZlASq3oDpOjXfhwluOzY74sy9elaE.png',
    u'Teve2 HD': logobase + 'tWjvTVsZwROaHw0WT4lajACjJ7IcKN.png',
    u'The Word Network': logobase + 'R9UwwsopX0YntvnH7OmrENwZrKhuIn.png',
    u'TiJi': logobase + 'mD3GW0E7rdPwc4stjk7xrLI2gZn4Hq.png',
    u'TLC': logobase + 'gT4olUY9nFJbGRCdwd7hHJp1NJ5eJr.png',
    u'TLC HD': logobase + 'gT4olUY9nFJbGRCdwd7hHJp1NJ5eJr.png',
    u'TMB RU': logobase + 'ejWH5qVf8XAWkc3HLQYTmEpYchtaIS.png',
    u'TOGGO plus': logobase + 'MgIYkMn6crZV90Bc8As0Ljg8L1p9uy.png',
    u'Top Shop': logobase + 'uD257Lhw7Ko2YD1reC0nRqW7lpy93D.png',
    u'torrent-tv.ru': logobase + '3LPFwCA0df8lBebrPhStZVoNWLMjvk.png',
    u'Trace Urban HD': logobase + 'VL7CokCNOQomUM5v9Wmhv2EcnMHdvY.png',
    u'Travel + adventure HD': logobase + 'b1HifWKMyefmDDvaDAJTwNNTaD8LF4.png',
    u'Travel Channel': logobase + 'fhmrYjlpC0YMxFd2RqOolbjlXMr0tI.png',
    u'Travel Channel HD': logobase + 'zfnAGLCvIu1fx9hfrITAZMoo9HYww4.png',
    u'Trick HD': logobase + 'g19Pt8UbGKOyNuHvCRlwe8HngcY9cB.png',
    u'TRT Turk': logobase + 'BDkqm302OLdoXCwpKFVUe8S43OlWj9.png',
    u'TSN 1': logobase + 'GJsJeixsOKvFaXz8XKqvX4Uh6sUicu.png',
    u'TV 1000': logobase + 'WJMEvVafVakrm7BUMy1lzku7VQCx25.png',
    u'TV 1000 Action East': logobase + 'GblbxkDGXZyW5oWt9W8wuERQAiZ7ZT.png',
    u'TV 1000 World Kino': logobase + 'A5HJc3MwXrOfesrvG8iCiWGnFYqFOA.png',
    u'TV 1000 Русское кино': logobase + 'ch5DX6f8hxDnmyzrjotUoKHNGzcw9P.png',
    u'TV EVROPA Bulgaria': logobase + '78SVTKvw7RzoIMaDyfjdH6tqRtGwF3.png',
    u'TV Mall': logobase + 'hao8n2RWJzxwNaiVHUawwkNVG6X4Zp.png',
    u'TV XXI (TV21)': logobase + 'TKchoTWZFRMmGDBok08zoEFJ8mJJCe.png',
    u'TV-4 (Украина)': logobase + 'aAcZbGFfyqMbiTybIo3eDV2gty3zFy.png',
    u'TV-5': logobase + 'iPHeoajUJttv5qZl2yfcOYB1qFx6nv.png',
    u'TV1000 Action HD': logobase + 'OdG0mEhFWsZehYaUmQRX2IdtPlGr7y.png',
    u'TV1000 Comedy HD': logobase + 'ygGiR2hkQLySH6khdo8GV9CyMJ8dXi.png',
    u'TV1000 Megahit HD': logobase + 'lVPY7WCjn1WM6NL6tfLFy8iGA4yk3Z.png',
    u'TV1000 Premium HD': logobase + 'raoDrpin8VKmi522LZWzSF0fLRO04m.png',
    u'TV3 Catalunya': logobase + 'JdogLgSiKoXxC7ZlxVLogeOLMQUQyN.png',
    u'TV5 Monde': logobase + 'ko7rbRBnyK1iINkLOA2adRvgVOEgUK.png',
    u'UA:Крим': logobase + '1oa1CrfXZ94gpdjszpFhOmEtO8mV6K.png',
    u'UA:Перший': logobase + '7jcbPt9G0pkO42ROJ6p0CbfyugTBXQ.png',
    u'USArmenia TV HD': logobase + 'llpqN7S6EpCPdoYIHjle6gc4cXlk17.png',
    u'VH1': logobase + '58.png',
    u'VH1 Classic': logobase + 'FhxUFQ2Bsfom4vb8Ce41gFObAbh1Vh.png',
    u'Viasat Explore': logobase + 'uCqpsdKP0ialUUYxUk2fXshYdYfxzW.png',
    u'Viasat Fotboll': logobase + '0JLqj3qwFoT1Y61scCyUdWioV5U6hx.png',
    u'Viasat Golf': logobase + 'IGpQl5iTxaDEPyKffdDEpU0EU0SPiO.png',
    u'Viasat History': logobase + 'MWGbB8wJp5Gm4vbPHl0ktohDDjMKdr.png',
    u'Viasat Nature East': logobase + 'yimDcPvajJcUKQm9bY15cDdp3rJFcp.png',
    u'Viasat Nature HD (Европа)': logobase + '6iBmDGCV7UArjU0ZkKnOZDcyB1FbYe.png',
    u'Viasat Nature-History HD': logobase + 'pSP6zxmuO4PU6xa6KRlZ9L8vvVM2Dy.png',
    u'Viasat Sport': logobase + 'prAZKkny3W1HGM03lP0EhzcMmTPZdi.png',
    u'Viasat Sport Baltic': logobase + 'ZIITckvF1w5u1MlubmhoG45HxPgcZZ.png',
    u'Viasat Sport HD': logobase + 'prAZKkny3W1HGM03lP0EhzcMmTPZdi.png',
    u'Vintage TV UK': logobase + 'mhFKSRmQIsgPnIUCWFzWbMAXK5dn3i.png',
    u'Virgin Radio TV': logobase + '6DgkEMl3HtkpKQbzVovPdSYhy9f3ne.png',
    u'Visit-X HD': logobase + 'PKLqXFmYlYpo1RbkynS7SfL79gH9fg.png',
    u'Viva Austria': logobase + 'sUPeS0888UCOztGNrzvtpXumWwg3ao.png',
    u'World Fashion': logobase + '2YI4sT9YkGezrw9vZPn0uIRhZ7E2BV.png',
    u'World Fashion HD': logobase + '2YI4sT9YkGezrw9vZPn0uIRhZ7E2BV.png',
    u'Xezer TV': logobase + 'ejWH5qVf8XAWkc3HLQYTmEpYchtaIS.png',
    u'XITE HD (NL)': logobase + 'N1zheznjGW9sV4i8GChlBD6sJ3009k.png',
    u'XITE Music  HD (GR)': logobase + 'FeWCTdXHZKnid3qXQNH7afhkBDdA0t.png',
    u'XSport': logobase + 'SCwOf3movQkrJf7ez4tNLZYlWo1b7t.png',
    u'XSport HD': logobase + 'CK1ynOTAF5wAvilMpyzryKKacuSdDl.png',
    u'ZDF': logobase + '5SH5FeZiITw27CPxscjksZp272u7He.png',
    u'Zee TV': logobase + '1HooaeEhMSvpKmWv6nneZxnTmG5r6Q.png',
    u'zhuldyz tv': logobase + 'rleCG7XGat4Ga9MTsfa7JwKQUsJGcD.png',
    u'ZIK (Украина)': logobase + 'dB1PmpYtgeI0C4u7Cv1QoXHlvc4JtT.png',
    u'Zoom': logobase + 'SyisYhg411o7z9kXci4vfpLq4KBZZ4.png',
    u'Абаза ТВ': logobase + 'ljGzZNT1OOt7L0J9gNql2yl39PbooN.png',
    u'Абхазское Телевидение': logobase + '3Mk8W64v1CqxF4S14K8pMNXSVFCthM.png',
    u'Авто 24': logobase + 'GZwKgvkC0vfYquFAn1dKhppNxdDit9.png',
    u'Авто плюс': logobase + 'WkRxjy6fJEBJ5NZiaGn2j05eqfFfQq.png',
    u'АЛА-ТОО 24': logobase + 'Qje1YfQEYAlYacMBfK8sGqCcJnLe7g.png',
    u'Анекдот ТВ': logobase + 'foqd1f29CWMTVE8bNziAGglAEgtGPd.png',
    u'Арктик ТВ': logobase + 'cwkVCO8OkPO5wNPC9bmVtpuF6iol2b.png',
    u'Архыз24': logobase + 'tuMbRlnkeMiYQ6u9oeiAVfHF0F20RB.png',
    u'Беларусь 24': logobase + 'GxA1KJP5YwpWc38BoPEmLwQH6uDeEz.png',
    u'Белгород 24': logobase + 'AePWQp63Dr37yC4Q7IGyYJl1T5X3a7.png',
    u'Белсат ТВ': logobase + '9VYuUQxx1ss7ieu2upENtlibyamBP0.png',
    u'Бигуди': logobase + 'JvcMdB5e6KVBpbXT12ulzmDqenheRx.png',
    u'Бобер': logobase + '2Edln8vEbg7UUSVUo7lIJPR780OWAR.png',
    u'Бокс ТВ': logobase + 's3qlrVrIjISf7K0G4HHRYw5rmAej4b.png',
    u'Бокс ТВ HD': logobase + 'mU9bGk24P0x0ggxiUvkj0LYOBY7QS1.png',
    u'Брянская губерния': logobase + 'V5M08NU3jRbd2wKvtVLIRbg9J6ObAZ.png',
    u'БСТ': logobase + '05dZ8fzOmf1lXYue2OvVsQ21eIeX69.png',
    u'БСТ (резерв)': logobase + 'e1Na3L3JV5aPefPbsE9U9VVdWMvkIw.png',
    u'БУМ ТВ HD': logobase + 'wHMGSLfPCHU2MX1y1ro6ZqQMxe0pcE.png',
    u'В гостях у сказки': logobase + 'j5XrmEogwV5wTwBqFC9G1pD3xw0Yyk.png',
    u'Винтаж ТВ': logobase + '6yngbEKfgy6XtMw28INQCoOdulf2tC.png',
    u'Вместе РФ': logobase + 'qa50GYekwBWym7KtoJdzrWHWqN8TeU.png',
    u'Вместе РФ HD': logobase + 'JxgnwFeOwqX02WHKKdkWJDoAtpWTCT.png',
    u'Возрождение ТВ': logobase + 'CKWaxJsLQYiJmnkLhtysIn8hb0NK8b.png',
    u'Волга ТВ': logobase + '1CZtoSAY9ZjEavNeGFTrPvSvFxjAHH.png',
    u'Волгоград 24': logobase + 'iCZ3kRKXWJITuH34sJ3HPRNedTtk4f.png',
    u'Время': logobase + 'F44yKDJQLsX0llpZ2wupg8V5vHx5fF.png',
    u'ВТВ': logobase + 'zgmRL374BuIBNBhkkoKUiEDeNMVvPv.png',
    u'ВТВ-Плюс': logobase + 'tPmijfGtbGhjmM4y3IT0PzuWbs6dz3.png',
    u'Галичина': logobase + 'ejWH5qVf8XAWkc3HLQYTmEpYchtaIS.png',
    u'Глас': logobase + '6m1xUI7vFyadFMFxXeIZjlATt7rlWw.png',
    u'Горизонт': logobase + 'f6wqkzO4WZW7D5Z9xIB4VkMRGmgXUU.png',
    u'Горящий камин HD': logobase + 'ujkL8d4MnAfrWSOBme8UxGFq6AJodT.png',
    u'Громадське HD': logobase + 'tHAyXEoFX2NzCPgAAsbymwTsL6eEEj.png',
    u'Губерния (Самара)': logobase + 'm6uotRQ8g6fjMLfVchecqsj0cbCITM.png',
    u'Дача': logobase + 'mX1irJVUyLtrXr9vfDdhknRqiqV9wA.png',
    u'Детектив ТВ': logobase + 'iXWgrqBGDDAT4qNehnEFDBBUu8qeez.png',
    u'Детский': logobase + 'jk8kody2p38CKdj5KGXWMwRLjgFIlG.png',
    u'Детский мир': logobase + '00Vf3rPABNnbNQ6Rv0dnfcg3JsJelA.png',
    u'Дисконт ТВ': logobase + 'jZ5txPxhQBePijTpiiWtH68Pp4My8G.png',
    u'Дождь': logobase + '381.png',
    u'Доктор': logobase + 'FznqTpJ71LS3RLESzMOHhNDxJMwBE8.png',
    u'Дом кино': logobase + 'jlC78Fy13KWjQUN6l3FtbsRLZDvc0x.png',
    u'Дом кино Премиум HD': logobase + 'Xg5l3gO5SnER0pwHhgsbHVMqSb42ty.png',
    u'Домашние животные': logobase + 'HiWAmn5RvUKNJnSW2Jhxjs6maoNFV7.png',
    u'Домашний': logobase + 'qmqrH2E2EX11qitbIvq0CYsxQjsHGm.png',
    u'Домашний магазин': logobase + 'yhzajV7vdLogQzMKat0rLJWaDkPpTP.png',
    u'Дон 24': logobase + 'qB34tCfiy8RoCwBprbt3yBlb9QTb7i.png',
    u'Донбас': logobase + 'vsj1IA3Z8QVL3AzzuN4EshgT4LUmRr.png',
    u'Драйв ТВ': logobase + 'uzYQb9aFsagXVHjM9hX3oeAbrY3k05.png',
    u'Еврокино': logobase + '34mszCG0j0Vf6kFcMrLPnFEA8UPdu6.png',
    u'Евроновости': logobase + '6HRWXfDaZ5zdwbwOsq383OrtV4MprK.png',
    u'ЕГЭ ТВ': logobase + 'dwe86aR0KHW2VzEyj863SViH9wtUGL.png',
    u'Еда HD': logobase + 'ojUD1jhpv7HBOLmubpEBOsANkpYNtk.png',
    u'Еспресо ТВ': logobase + 'lOwm890F5URuR5Ej7IacerzECPIDt4.png',
    u'Живая Планета': logobase + 'xgKSMwqBdEyXnbVgb8LtNXSMiaPcOx.png',
    u'Живая природа HD': logobase + 'L9qmq6UIprbg4VBQA46tqRjQ22thsp.png',
    u'Живи': logobase + 'cOluSjslxxs3JZtSVO8c15xh7h8SDU.png',
    u'Загородная жизнь': logobase + 'cGGo8HRkVhy66UXKXZ4tH5HyUaaxJA.png',
    u'Загородный': logobase + 'RX345W0BBqJbR3XdROHMi4dnbwqwlt.png',
    u'Звезда': logobase + '0HLRrFHt2QIkbJpLc1fy0RVe7hqCEC.png',
    u'Звезда (+2)': logobase + 'wa6skHc8W2MRz9Mm3qoKS4LpctSvYs.png',
    u'Звезда (+4)': logobase + 'OuOzOS8YQYpfvSiALYw8RE79MLLW8a.png',
    u'Звезда (16:9) !': logobase + 'gPzH1fd9puL4joFkEcLAo3C4rc9XR7.png',
    u'Зоо ТВ': logobase + 'RtAhntWPlKQs6CIYAb72piNF9EsN3E.png',
    u'Зоопарк': logobase + '1Ugpb5T1THFcFpn19Mnua21KxHkjct.png',
    u'Известия HD': logobase + 'oDcPw8gfynentKu5CDXKlA0lo86tdK.png',
    u'Иллюзион+': logobase + '8LToTNvWRBHvb5IKoteKm8EwAGw8mv.png',
    u'Индиго': logobase + 'dFIp5shmC5DbfWIDVaFh7coAofmLON.png',
    u'Индийское кино': logobase + 'y8wvb5nc77vn5c4x8kinv85c7mv6n875c84.png',
    u'Интер': logobase + '3SP67FapzyZqMVZTPiJIcN09KRkTeu.png',
    u'Интер +': logobase + 'gwNJRUrxiQUP4quofAUZwjfn470AkS.png',
    u'История': logobase + 'PNRaeOUFzOPFtrclFBBRTckj6Lvo0u.png',
    u'К1': logobase + 'mk2mYb28HFIxkFIiMNQWmKUdn1Y8hD.png',
    u'К2': logobase + 'IjG76jf8k8HTNLooNpUiEXtkPfA2rG.png',
    u'Калейдоскоп ТВ': logobase + 'YJMqmzlZ87QeXYm9XpjH0XzpjljNcU.png',
    u'Камеры Санкт-Петербурга': logobase + 'jHbY0LrB7JKBBWzWC1ctPD6uDqQNnx.png',
    u'Карусель': logobase + 'S233D4b6eq7KOXfdyi4dY2GokKeltg.png',
    u'Карусель (+3)': logobase + 'cYXQq7FnkEBAyYxfoPPsL2y3fwMDKU.png',
    u'КВН ТВ': logobase + 'uHs398usENAAKycx5NFCHiC0jDtzrc.png',
    u'Киевская Русь': logobase + 'C1AZimW2NnNA17H1uJLxxePUMTPQZ7.png',
    u'Кино ТВ': logobase + 'KkITMDICqC1erWdSqyOqoccqde2wHC.png',
    u'Кино ТВ HD': logobase + 'NGQLEmlltpslVNKkD0htUF7CogGXqX.png',
    u'Кинокомедия': logobase + 'y087hci8ityixcnyxinxoafhiu.png',
    u'Киномикс': logobase + 'y6b876ih8g7R876hfug3897wrhj.png',
    u'Кинопоказ': logobase + 'L2qsABeMEDKOSG4Tvh7XpfvX2BfksG.png',
    u'Кинопоказ 1 HD': logobase + 'pNA1vR3sPoovYNKzO4TU6NQcSXNqjk.png',
    u'Кинопоказ 2 HD': logobase + 'Yf2XKrtorOF2wSZ23Q9NHhL2MfOcqi.png',
    u'КиноПремиум HD': logobase + 'p580CRZ8bBS6dw3plMWhhxXSzQ59uS.png',
    u'Кинопремьера HD': logobase + 'y4Ihg8o7ikgJHF768iJHFH76iu.png',
    u'Киносвидание': logobase + 'y1876iuyf7645urjg56utfy.png',
    u'Киносемья': logobase + 'y2oerfuhdj2108nbs4ev875esk47dn.png',
    u'Киносерия': logobase + '4TMYdVpZYXafyIumuB5d7PrjFnslyT.png',
    u'Кинохит': logobase + 'y3igbjZ&LGyqDWGIASUY78AWID.png',
    u'Конный мир': logobase + 'd8gVne1Em14rIfM6pSsiuufXZeYQqi.png',
    u'Конный мир HD': logobase + 'q87VlmfaBeBhq8SOhAu0SVPEGjiqWM.png',
    u'Кот ТВ': logobase + 'Rtdtc632nbBQ2TsymgXhkOt7nhytjW.png',
    u'Красная линия': logobase + 'I43S6jd5noclar0LlPJnyY8adonmUV.png',
    u'Крик-ТВ': logobase + 'bYwacGhYkGwDoMsjGpDbltdCwMJSHJ.png',
    u'Крым 24': logobase + 'x4s9QQXR8KerO13nlkuEujzcv5ww5F.png',
    u'КТК': logobase + 'BhI4KURCZ3fAgCQcwQWn7vRCJQblH3.png',
    u'Кто есть кто': logobase + 'MwNkO3fXd6KefRdiGlOdOQ5q0Zu7kS.png',
    u'КТРК Музыка': logobase + 'jqiucXUHkE8UkC4QqeQMt8jcldpJkh.png',
    u'КТРК Спорт': logobase + 'x81GWJrYa6mbtQj36q0pg9QnhCKxR1.png',
    u'Кубань 24 Орбита': logobase + 'FauvJxsKmI5a1fR62uSH9hJfHs5TCr.png',
    u'Кузбасс 24': logobase + 'E6ftIMytwxMxG1pbehfWfXdqn0iofP.png',
    u'Культура (Украина)': logobase + 'pyKdve4YhoChQFGSha8J0FBWBf302a.png',
    u'Курай ТВ': logobase + 'A0onEnFhSzqGxckeyyXsf0ZQ4R3Vc6.png',
    u'Кухня ТВ': logobase + 'G0WbVMphlP9oJ6KvHRfx0xDfhrF9Re.png',
    u'КХЛ HD': logobase + 'kRN7BwVtcdaXrU4Mdg24qhFAxjx9oZ.png',
    u'КХЛ ТВ': logobase + '216.png',
    u'ЛДПР ТВ': logobase + '1keO0CoTmw0B3VZRe4TZnzfGdKDqSj.png',
    u'Любимое ТВ': logobase + 'qVREQyj0rN87jDZ1ylYW0sDvzfNp8p.png',
    u'Ля-минор': logobase + '8FJA3xMMHcrZuGifHViyVQLjVIem5u.png',
    u'М1': logobase + 'ezvu2ugYMGnZ968LlnjPw7VjqWIPeM.png',
    u'М2': logobase + 'U4s78hznNz7mFYZQICkxN7J0HTtlCP.png',
    u'Майдан': logobase + 'ejWH5qVf8XAWkc3HLQYTmEpYchtaIS.png',
    u'Макс 24 (Сочи)': logobase + 'EkfRx44dYCkUuU7g0bM5jJz3bAASBG.png',
    u'Малыш': logobase + 'lawBkwFuj6qiu3jZQGLnHJUc9wGPwM.png',
    u'Малятко ТВ': logobase + 'kjYF9vS2IDTMehpzC7WWfjnZ4NVpuk.png',
    u'Мама': logobase + 'nw9fROQIjjKSDp8Wjkjl1Wt0n0xHxd.png',
    u'Матч ТВ': logobase + 'hQDOuQjUVczvUU2ocLE0tkC1siCqpo.png',
    u'Матч ТВ HD': logobase + 'MXyy9Uud7oDuH8JqVisjsD0csgAHnQ.png',
    u'Матч! Арена': logobase + 'DDjh1dM2D09Wcl3L6YmEd1si3P17n0.png',
    u'Матч! Арена HD': logobase + 'DDjh1dM2D09Wcl3L6YmEd1si3P17n0.png',
    u'Матч! Боец': logobase + 'xj1tPp6g9LmQH5KAN0gFpWYoa9RdbL.png',
    u'Матч! Игра': logobase + 'urIB7TbFWo36EmXW9eG3w4qre7MdX9.png',
    u'Матч! Игра HD': logobase + 'urIB7TbFWo36EmXW9eG3w4qre7MdX9.png',
    u'Матч! Наш Спорт': logobase + 'l0x8GopxrHL6jLiDGVHi8tIEc7RBt2.png',
    u'Матч! Планета': logobase + 'mWQ92sSmszzmjme9GTueLPCxagJGtl.png',
    u'Матч! Футбол 1': logobase + '9PM8M6cN21wQ3M5isVZgjNepzUI4Ry.png',
    u'Матч! Футбол 1 HD': logobase + '9PM8M6cN21wQ3M5isVZgjNepzUI4Ry.png',
    u'Матч! Футбол 1 HD Резерв 1': logobase + 'HWZYoNrs7kQimfhyzT8V2d0WvBRbEr.png',
    u'Матч! Футбол 1 HD Резерв 2': logobase + 'jJsAF2rxef4RpccQrmfPkIbJc9kS7Q.png',
    u'Матч! Футбол 1 HD Резерв 3': logobase + 'Tpv0BbEi315Omo6MKh3ZiX5zTzc8OT.png',
    u'Матч! Футбол 1 Резерв 1': logobase + 'CWit8nYXCcCsmB6KbIedlKwFWWTyZT.png',
    u'Матч! Футбол 1 Резерв 2': logobase + 'n6kF2auPAk8bMH2zray20zP12QKL1Z.png',
    u'Матч! Футбол 1 Резерв 3': logobase + 'ipK5bpcm9mR9COdolCiHV6csIndprl.png',
    u'Матч! Футбол 2': logobase + '8MA3WloO6RsWX8N7Ck5ugek2Kirf4B.png',
    u'Матч! Футбол 2 HD': logobase + '8MA3WloO6RsWX8N7Ck5ugek2Kirf4B.png',
    u'Матч! Футбол 3': logobase + 'OLHdmyfUev4mMX0OGniJrlUwHnMKOg.png',
    u'Матч! Футбол 3 HD': logobase + 'OLHdmyfUev4mMX0OGniJrlUwHnMKOg.png',
    u'Мега': logobase + 'IXY7dRFoq0qCqn4UbY47iP36vVZ6ck.png',
    u'Миллет': logobase + 'zDsxAdZp80tZ43Rd2IWAgFOFFYDkwh.png',
    u'Министерство идей': logobase + 'k9RMWD6a1nooGeVYJd5ULWhAx7nsTP.png',
    u'Мир': logobase + 'Oq6h2IicTagHENQu1mFkjLk5rChMnr.png',
    u'Мир (+3)': logobase + 'QxOYkz6f80IdhmC4RSHI1cMd32CqYZ.png',
    u'Мир 24': logobase + 'auv6717gJOWi0A2VoeDQaCsx9G1NOj.png',
    u'Мир HD': logobase + 'Oq6h2IicTagHENQu1mFkjLk5rChMnr.png',
    u'Мир Белогорья': logobase + 'JRU6TyiBAX5Fk84DebhKeSxg7ZkrEf.png',
    u'Мир сериала': logobase + 'XWDsU7aoUyPPoKfcX7WMYQheuzHJL0.png',
    u'Мир увлечений': logobase + 'KtELENmDesBwzAAryLgJPqwlr9m17z.png',
    u'Мой мир': logobase + 'cHearBQvhJZUmqc30x3W2yJZHC68MX.png',
    u'Морской': logobase + 'uzlb3awoyNqvIcf6i35hTVqf7gvuqz.png',
    u'Москва 24': logobase + 'dZcmoqRoZLhCBh8BE4RnbQivuDY6hH.png',
    u'Москва Доверие': logobase + '9oPazhJQrGZcSN64ZOS3WjLwGmQIZy.png',
    u'Моя планета': logobase + 'Qa41eifERrD77xQsmpRGbeTq95Ldlv.png',
    u'Моя Удмуртия': logobase + 'l3xs5mws4kXBWbsjeVzS7tp9zttrpp.png',
    u'Мужское кино': logobase + 'y997iu65e65h4w5d3s4dy.png',
    u'Мужской': logobase + '6YbhuWNqPKQWWsUGbBnSbAbm7IGssX.png',
    u'Муз ТВ': logobase + 'gttVvZmkAklbl2i0Mqy1MCzSCn7WiY.png',
    u'МузСоюз': logobase + 'E4a3fEpdSy2c8AnYEdR8ZIFgFe2LAP.png',
    u'Музыка Первого': logobase + 'fD2Hnsq5BPMGvobLDMPZP049yNhBYt.png',
    u'Мульт': logobase + 'ZVzHvGF8mZ6RTsSh6aWsPbF1FBLjyp.png',
    u'Мультимания': logobase + '132.png',
    u'Надежда': logobase + 'fvCkzRJPsTx4HONWPv3vPMjQNloPBT.png',
    u'Нано ТВ': logobase + 'QuURIfJUmXegxsHMYqMivVwxizbfKd.png',
    u'Настоящее время HD': logobase + 'Wh8dHDWVAik29wT1fdzdB9QClZ2PWv.png',
    u'Наука': logobase + 'ejWH5qVf8XAWkc3HLQYTmEpYchtaIS.png',
    u'Наука (Украина)': logobase + '73jfedkdp1PVWxdlddOvbwe5HqVEW6.png',
    u'Наука 2.0': logobase + 'ypWbqYqKApM8cnDK1FibvQgpmgEay9.png',
    u'Наш детектив HD': logobase + 'ORgdUno4IvNQYiShiEY4srF16JguLs.png',
    u'Наш кинороман HD': logobase + 'NyV9o2C4xIMFxxYUQsS1qsdAtkqz0k.png',
    u'Наша Сибирь': logobase + 'zYJLNsu4daR3jomBUtHPWgeSFQo7Bq.png',
    u'Наша Сибирь HD': logobase + 'VbmHqKo1RHl1fkZym386Pc5wTkNM70.png',
    u'Наше любимое кино': logobase + 'LSR5M6VxB0YDwv6803zrGFkq7vGQ3J.png',
    u'Наше новое кино': logobase + 'y5jtghJCHG65ukyfjv 45stjxc76.png',
    u'Наше ТВ': logobase + 'gTfxpSWtOGWBq7UHAHcz3XF10bzg78.png',
    u'Неизвестная планета HD': logobase + 'Gvam2aif9yVwK5YjswZ43GQOwc9ZBJ.png',
    u'Нова ТВ Болгария': logobase + 'WwgAjjB4yzi7zTG2O5Q0wUUz83O5Eh.png',
    u'Новороссия ТВ': logobase + 'YXClYch7fOn1YzpwKjWqjMyPQa2RsV.png',
    u'Новосибирские Новости': logobase + 'wN2tOSdrmMjKWUll48Oygdk3ROh9Aj.png',
    u'Новый канал': logobase + 'k7YdHhVpFZPIkBMXS2P2O2TkZSPf0y.png',
    u'Новый мир': logobase + 'K0Oy2d445QmB0921HH1aB5JWUGScto.png',
    u'Новый Христианский': logobase + 'gf6hTOcGXasvr47vTFRYZGV11xkDr5.png',
    u'Ностальгия': logobase + 'tIfiXoDaXoZevuGu9pZJSvX8unv1xl.png',
    u'Ночной клуб': logobase + 'nXifSdkxHJVKI4SKtgtBQmCSHXtgOt.png',
    u'НСТ': logobase + 'fKYzdlWRz68qd9mRZnWuxMY73EyaSz.png',
    u'НТВ': logobase + 'B5GA1cfgmn8EsxrdwfNUIrEbdqarXf.png',
    u'НТВ (+2)': logobase + 'B5GA1cfgmn8EsxrdwfNUIrEbdqarXf.png',
    u'НТВ (+4)': logobase + 'B5GA1cfgmn8EsxrdwfNUIrEbdqarXf.png',
    u'НТВ HD': logobase + 'zdJ3ye6d3UWl5a56zm6LjqYH6ziSOs.png',
    u'НТВ Мир Балтия': logobase + 'ykpU49Gl1akVkgiVSsCm5B4TjXvQ64.png',
    u'НТВ Право': logobase + '7yNDqWT8KiQ2aa9kGYXSsnVFCPj5xx.png',
    u'НТВ Сериал': logobase + 'T7amR78JUYW3EgFZp14hQdh7pjzWLJ.png',
    u'НТВ Стиль': logobase + 'DjeH6JTGT2hH0Y1Vfwd9Cceg780nNl.png',
    u'НТВ+ Инфоканал': logobase + 'ejWH5qVf8XAWkc3HLQYTmEpYchtaIS.png',
    u'НТК': logobase + 'ix3lD9BcsoKou0MIhUCGgKF9MypV1g.png',
    u'НТН (Украина)': logobase + 'LpQE1Odb1EoH5dJ90gWjItVyEYBXsw.png',
    u'О!': logobase + 'zHhfMQhsdu59e6puujg0qHt1675jYO.png',
    u'О2ТВ': logobase + '7KCLIwxu4Rfly2aMpR8zWBGvpv1Py8.png',
    u'О2ТВ HD': logobase + 'KEq35DyCm6eZhUR49IglOsSLvBdmDy.png',
    u'ОНТ (Беларусь)': logobase + 'a84If8XdqSFa6nHpegdujt52vAGNJW.png',
    u'Оплот': logobase + 'o6U3Rw8Ts9R3ctV5HTjGYEXxb6AJeS.png',
    u'Оружие': logobase + 'CyDUCmYXK8WS2kXCX5kiAOFejnlwoP.png',
    u'Остросюжетное HD': logobase + 'mxF7CZsqsDRMMK4pN8ekdccEgvEsZC.png',
    u'ОТБ (Харьков)': logobase + 'JiLpVicaO0fGahxYY5HqzEGe6rbUdN.png',
    u'ОТВ (Приморье)': logobase + 'W3FNGLfo7R7JpYI98Am5sGamz0bfaN.png',
    u'ОТВ HD (Челябинск)': logobase + 'PJ6O6K8WcAZihwqeWkAyHnBY0aazCq.png',
    u'Открытый HD': logobase + 'CdIvMNsa7gAihJnpAKX8QnMdpvhAXc.png',
    u'Открытый мир': logobase + 'vzFPGE5EMEh8ilV1WIGYcCKwYVVTSZ.png',
    u'ОТР': logobase + 'CqxKorK72v3ULbWkB3ZOhdte0duYZa.png',
    u'Охота и рыбалка': logobase + '5l2P20J6ebTh0ptOr27Hh704niP3nU.png',
    u'Охотник и рыболов': logobase + 'Ws2ddPI0b5Ie7PymoPUsboVlz9lYMS.png',
    u'Охотник и рыболов HD': logobase + 'O0wexOqiQXKMwr2coDMKWvJEb4zLQ1.png',
    u'Первый Городской (Киров)': logobase + 'DoKQvt9mUUYEwhXbO4M6PgGOAhok1X.png',
    u'Первый деловой': logobase + 'a1Qf3MpxC9FPD68Tj8vtUTNK8P25xr.png',
    u'Первый канал': logobase + 'WimZD6efLd6QotrPP9uiJeF7t50nFv.png',
    u'Первый канал (+2)': logobase + 'GGe1ttMtczS0mgzMCegYji57J3PIaJ.png',
    u'Первый канал (+2) (16:9)': logobase + 'Vzz9xtVJcWtpfAh4mmz8AreS3FTlae.png',
    u'Первый канал (+4)': logobase + 'nUznF8VjPtO3KwbjlU0KaSWhutRRaL.png',
    u'Первый канал (+6)': logobase + '0FNeH92R3NfkxmqF5kGJegh7wFS8lP.png',
    u'Первый канал (4:3)': logobase + 'WimZD6efLd6QotrPP9uiJeF7t50nFv.png',
    u'Первый канал (Евразия)': logobase + 'oPB8TcSFAuJtk4hBWgAqC9yNjMpfsi.png',
    u'Первый канал HD': logobase + 'VxAFWzh1y88c8Aqa17TsxD2IO5pqoi.png',
    u'Первый канал HD (+4)': logobase + 'VxAFWzh1y88c8Aqa17TsxD2IO5pqoi.png',
    u'Первый крымский HD': logobase + '83MCfIk9L2xgpTAs9UlPS3Ufsg0EVG.png',
    u'Первый Метео': logobase + 'vdA7FKd1SCYhX4ovvzjQEHFdW3uA5X.png',
    u'Первый музыкальный HD': logobase + 'YxKl6Jqi6fmlUJjYGPnBhWhntKzI65.png',
    u'Первый музыкальный UHD': logobase + 'YxKl6Jqi6fmlUJjYGPnBhWhntKzI65.png',
    u'Первый музыкальный канал': logobase + 'gYpYhzD3akuKSFpRmkh2p36pXnqHoW.png',
    u'Первый музыкальный Россия': logobase + 'MkX2WG1zhZ2KcYFdL0xWH1T4xkO7UW.png',
    u'Первый музыкальный Россия HD': logobase + 'h7EDhdGypKmtfEP98O052SLlXUCcXt.png',
    u'Первый образовательный': logobase + '1kXxtStMuodaPU09H3rla3ry3QA2Wr.png',
    u'Первый Республиканский телеканал': logobase + 'VyJcFlIDs6xMLIHocDdpb9WeE0JDII.png',
    u'Первый Ярославский': logobase + '6FZ4QqwM18DLS3WE6XKeF0rJzpSAIH.png',
    u'Пёс и Ко': logobase + 'Lj9LwC8sHiSvUM6XDraDuKQPWf1BKK.png',
    u'Пиксель ТВ': logobase + 'BdCXB7wPZMNvlWzB5xEFzmsYUXcfXW.png',
    u'Планета HD': logobase + '1QjirpCLi3q9qPu1CTvEvCB0BfINeo.png',
    u'ПлюсПлюс': logobase + '6gVIy7RMokFO61iVawgwbthe5mhgqm.png',
    u'Поехали': logobase + '0tjsemk0EPOCa1EKOlwuow2Z9jxXyf.png',
    u'Правда тут': logobase + 'ejWH5qVf8XAWkc3HLQYTmEpYchtaIS.png',
    u'Про все': logobase + 'S2i01pmEOFJxwJtJCVF7PYc6Ij4jBX.png',
    u'Про жизнь': logobase + 'Robm1kzCcV401H7oo3Fyh18OFOwXRW.png',
    u'Продвижение HD (Омск)': logobase + 'qmaGd81WFsVDntpeM8KcNU1mATTV4N.png',
    u'Просвещение': logobase + 'Fpx3Vqqk2VNcXl4YjsfO53XscWadvF.png',
    u'Прямий': logobase + '38BRA5jO6LAsQ6rv1NC3FMJ6KALp8z.png',
    u'Прямий HD': logobase + '38BRA5jO6LAsQ6rv1NC3FMJ6KALp8z.png',
    u'Психология 21': logobase + 'AyLAdiqcKu5X8ykdLf2bO9HsxMlJdO.png',
    u'Пятница': logobase + '0fafj6PSIWdqtBdgwYTl9M06SDU2wA.png',
    u'Пятница (+2)': logobase + '0fafj6PSIWdqtBdgwYTl9M06SDU2wA.png',
    u'Пятница (+7)': logobase + '0fafj6PSIWdqtBdgwYTl9M06SDU2wA.png',
    u'Пятый канал': logobase + 'nIUDYY41OO4Xo0ntGpGv2rfpOR5ngt.png',
    u'Пятый канал (+2)': logobase + 'rsEtkBk2ta1Wj1Y8uvxvSm4Vmbycir.png',
    u'Пятый канал (+4)': logobase + 'jLZJgPYRXOQWt6vmNpisLyb0HC6wnT.png',
    u'Пятый канал HD': logobase + 'SYEopR9w4oAuBjJKULqiDvAxtB36W9.png',
    u'Рада (Украина)': logobase + 'hBFJBYNiqZUom0ooVtNEJKliZwfioO.png',
    u'Радость моя': logobase + 'VRylZFYgFq7AL0FWcbf5JVOX3desn3.png',
    u'Раз ТВ': logobase + 'CWaPSXdAL4Ejo1wNOqSWNPNVwbbhC7.png',
    u'РБК': logobase + 'JUMDXZxxB3UiVpMpU8t0aCpbVzxTmP.png',
    u'РГВК Дагестан': logobase + 'qn17bOV3KKdSlA4iY9wM3QQGjSYv9f.png',
    u'РЕН ТВ': logobase + 'LJvkfB2kYaDzij1Y13Fy6syUCkP5Y6.png',
    u'РЕН ТВ (+2)': logobase + 'LJvkfB2kYaDzij1Y13Fy6syUCkP5Y6.png',
    u'РЕН ТВ (+7)': logobase + 'Vs2UxW1Qw5caI5D1xU3J39tVm39SlJ.png',
    u'РЕН ТВ (резерв)': logobase + 'KMIosCGWDkcYCFeiSrqOBFxXIDxSHu.png',
    u'РЕН-ТВ ИСТОКИ - ОРЕЛ': logobase + 'G9eQwShtkUavBqrQnprfYLZEbTVCxH.png',
    u'Ретро ТВ !': logobase + 'IQNV43xGiDarnJoh6G4klfCD3I4kls.png',
    u'Родное кино': logobase + 'y7saqicb538iqo64ho46hh46.png',
    u'Россия 1': logobase + 'UUrfoqi6NQcc9gRLnCc8ODZJ2T3ShE.png',
    u'Россия 1 (+2)': logobase + 'TmknFdEdaX9GxcJhqd856oKgv0o1lp.png',
    u'Россия 1 (+4)': logobase + 'buzygzarNA0VXEEKSE2oMALmjSxwao.png',
    u'Россия 1 (Мурманск)': logobase + 'iyNAFKplpz55eyI2QzZpOpoI4T6mSL.png',
    u'Россия 1 (Чита)': logobase + '508Yuw2bkpv4J4x9LYXOPayVeBbbrq.png',
    u'Россия 24': logobase + 'LWfGV6eICPYL7psaBfw2dOgGrOtHFS.png',
    u'Россия 24 (Мурманск)': logobase + 'CjtIvIg7sTZSlUKXuEVBxchSB8voQp.png',
    u'Россия HD': logobase + 'ghvqmVpPWqn9x6POAm9UJBvXFzTrqN.png',
    u'Россия К': logobase + 'W9pWrec1BOJTmj8okrFeyM44wcpyd4.png',
    u'Россия РТР': logobase + '5o9OWeEw90hM5ouECuTLwj5QP8MwU3.png',
    u'Рудана': logobase + 'sHD2d6haQuqacBMkqiHcrCYJwMed8J.png',
    u'Русская комедия': logobase + '4Q3vGcJh5o0cgJB18scb90ogvL6OYV.png',
    u'Русская ночь': logobase + '9Sh9bJuj6js5AJsypAd6UvwnsIB25R.png',
    u'Русский бестселлер': logobase + 'b5JXaosgmcanh9EVJg52yBefvdLQF7.png',
    u'Русский детектив': logobase + '7I7VjbsFMIkZdoSbHFXiKEVZKNUbOM.png',
    u'Русский иллюзион': logobase + 'E9Imfr8aHN5midPVpNhJ3fo49FHbQE.png',
    u'Русский роман': logobase + '2smriIFxtj7Ojh4jyZq0K1XrT98XjS.png',
    u'Русский роман HD': logobase + '2smriIFxtj7Ojh4jyZq0K1XrT98XjS.png',
    u'Русский экстрим': logobase + 'upndVpIdjY3vb5vrituof5UcKISNcQ.png',
    u'Русский экстрим HD': logobase + 'upndVpIdjY3vb5vrituof5UcKISNcQ.png',
    u'Рыжий': logobase + 'wfBSy60qHaPSKPpTfrNv9Q167iHIPu.png',
    u'Рыжий (сурд.)': logobase + 'GVloiNkHEd8z66ZjQicsIOkjeInnru.png',
    u'Санкт-Петербург': logobase + 'sb81YtPOvlHidztMnC5tZPSKkb1uMI.png',
    u'Саратов 24': logobase + '5MeGeK5GeEkVWdYKsfFVpcvUcbs39S.png',
    u'Сарафан ТВ': logobase + 'LsYzwEOUspoxkY2hrTSy9zKqvpWlY8.png',
    u'Светлое ТВ': logobase + 'TI5r40h6Un0bHj8MIVkx6qMJRJTHqa.png',
    u'Своё ТВ (Ставрополь)': logobase + 'sZC9lsS9y83orqXpovNOhcP7RdTmzQ.png',
    u'Сказки Зайки': logobase + 'ate5hd5vMAzbydl6dVpG6CMyxnqKnE.png',
    u'Слуцк ТВ': logobase + 'wty5VfAnYYhOUcThWeSgeaH62b3m5b.png',
    u'Смайлик ТВ HD': logobase + 'l4eM2nWbsJxQNKgUP7D4XZ96ieTkb6.png',
    u'Совершенно секретно': logobase + 'BZJQEpa6Y4KL9tQjPHAIxbodw0KAyN.png',
    u'Сонце': logobase + 'TJXJVeoBFRMFrUgzpPW4dunJL6XSzn.png',
    u'Союз': logobase + 'YpsuBorUwulPHW3nI8O6nKETnEVB83.png',
    u'Спас ТВ': logobase + 'pAFeyS1iCV4BybnpnnwjoKm0y0zvaA.png',
    u'Спорт 2 (Украина)': logobase + 'caui2OjRMPFWAFtfDnfCG4P1qt7uQj.png',
    u'СТБ': logobase + 'saZlIDrdaXWoiQa8sfZp2bEAeH0kXk.png',
    u'СТВ (Беларусь)': logobase + 'XX9KxgBXMkvJkP1PeUshGI1pe43Huc.png',
    u'Страна': logobase + '5G27bahViND43dD1VlkaKlQRsYOqwL.png',
    u'Страна FM ТВ': logobase + 'ysrRW9deFkccNGlhtT0Sww5Yt8IpY1.png',
    u'СТРК HD': logobase + 'xOmVS1kQFIHeAwqtJbBfrbE75Quj2a.png',
    u'СТРК HD Сочи': logobase + '2PphESGueDUS1T6wSOr12iTgTbIVJm.png',
    u'СТС': logobase + 'is620Pu6DreVLLnpHkpcXXZC9PI2Hi.png',
    u'СТС (+4)': logobase + '9kPWMgG96ZZcBeleMogGOHKZcsOARf.png',
    u'СТС (+7)': logobase + 'qxxLwx53wKNngJTCtT126zgZT5Wi1x.png',
    u'СТС (резерв)': logobase + 'is620Pu6DreVLLnpHkpcXXZC9PI2Hi.png',
    u'СТС Love': logobase + 'iciJHbEmJ1hHXAMhzC9cRWhmh9gH0L.png',
    u'СТС+ТВ21 (Мурманск)': logobase + 'qXdXqfxDK23uC5srFGAfOlzmaUDYe1.png',
    u'Тагил ТВ': logobase + 'ubegTi3hkdx7xtZCdOz8K0gBQLlght.png',
    u'ТБН': logobase + 'r9O7HmwQbFR4oKMH9yKAogE8xBzwz4.png',
    u'ТВ 3': logobase + '427.png',
    u'ТВ 3 (+2)': logobase + '427.png',
    u'ТВ 3 (+3)': logobase + '427.png',
    u'ТВ 3 (+7)': logobase + 'HfEo6PctsuTnlPQIa0xVKgEDqFwI48.png',
    u'ТВ FM': logobase + 'A3YxOjZfAw2KJ3naZrCznXfdlotAlw.png',
    u'ТВ Центр (+7)': logobase + 'diq0UxVTgqVSQn8KpcYCqe1Tk9q9Wh.png',
    u'ТВ Центр (Москва)': logobase + 'F4YXd72KBNgv5iZVXrdPA28uGwISso.png',
    u'ТВ Центр Международный': logobase + 'QEpQTskZ9hcfI0rgD8osHVYSv58pde.png',
    u'ТВ21+': logobase + 'jir42UhUeeHKMrpUMCfnGdECmP4E5f.png',
    u'Твой Дом': logobase + 'TJCGg7LuuUfVsyv5IFjMPLAGZmlNNL.png',
    u'Твой Пушкинский': logobase + 'bGue6qSxFjWrP6DjWxeHj8fBBhB161.png',
    u'ТВЦ': logobase + 'QEpQTskZ9hcfI0rgD8osHVYSv58pde.png',
    u'ТДК': logobase + 'eSrHE6Gws4U6JxhFXA3mQ4iDVc0SwS.png',
    u'Театр': logobase + '8qawrcOtzHZTAa3kI0rcDfVFEZoI5u.png',
    u'Теледом HD': logobase + 'XviuCfRo0T4WFTOhFaC978AwZ1a3Ge.png',
    u'Телекафе': logobase + 'fYRFV5oY197jXcyModfWVs0AlrCOIs.png',
    u'Теленовелла': logobase + 'VmrH6tFL11avii735fJeVryZtEaCQ3.png',
    u'Телепутешествия': logobase + 'fz4bqwLySJAQkUN7l2EPKNqyvilfRD.png',
    u'Терра': logobase + 'GfIwWExYktvecczAx1jL64Rk8xdyea.png',
    u'ТЕТ': logobase + 'jp0YxRwXOyMWgVfDAyQaXNwle90sV3.png',
    u'Техно 24': logobase + 'JbUGHLuuZa3WQbjtbzUo0cDZkGnLRK.png',
    u'Тиса-1': logobase + 'pPRRy0SjPl3JKXdcZrQrdXQz3NTKOH.png',
    u'Тлум HD': logobase + 'FhxsethirEr5lhrE54VGA4acHu7MJn.png',
    u'ТНВ-Планета': logobase + 'vBMv8AtIpDhBGQLjPoxkko3baWMFac.png',
    u'ТНВ-Татарстан': logobase + 'kMdYm3qFLgK52EV0ymvRBB43peSrj9.png',
    u'ТНТ': logobase + 'Vtt1KKIpLY4LTQGnV03sdBYyX3hyWR.png',
    u'ТНТ (+2)': logobase + 'Vtt1KKIpLY4LTQGnV03sdBYyX3hyWR.png',
    u'ТНТ (+4)': logobase + 'Vtt1KKIpLY4LTQGnV03sdBYyX3hyWR.png',
    u'ТНТ (+7)': logobase + 'lBHVGkAE8EVjDXLQGl52H6HTLavzBR.png',
    u'ТНТ (резерв)': logobase + 'yEDrU5cgZbdUgfq8kzb40581xLcXNy.png',
    u'ТНТ HD': logobase + 'iD2Gi2nqvSSZnrtPeaqAp6M3NpD50v.png',
    u'ТНТ International (Беларусь)': logobase + 'd4loXdWqOPiwF7thzyBXX8JSspfVjU.png',
    u'ТНТ-Music': logobase + '6Go23tY9hpakfrvTEUH7Z7o5Y9hpOG.png',
    u'ТНТ4': logobase + 'yTclqOAW0EWwhw9vt0spVSUcS70ZR0.png',
    u'ТНТ4 (+2)': logobase + 'yTclqOAW0EWwhw9vt0spVSUcS70ZR0.png',
    u'Томское время': logobase + '1Z7yLtfyuITQhXchO59gwyQ3mES7qS.png',
    u'Тонус ТВ': logobase + 'bE8WfReOerYTIbqPOo6VD2ajrFdOBT.png',
    u'Точка ТВ': logobase + 'JWwPbPnkWooIpKd5WYsdpfO3Mh14oA.png',
    u'Третий Цифровой': logobase + 'MXcua7OlJ9CplpD15hD84Xn2QjoCdt.png',
    u'Три Ангела': logobase + 'EphQD4X09CGs9ukmPVM5FpmQBSyvch.png',
    u'ТРК 555': logobase + 'z3GvW4WdjwSmsQrfhAIZewEsdH0rsi.png',
    u'ТРК Киев': logobase + 'qW0p5z3De7COmSxTmvJ4ZA2wOuSJjg.png',
    u'ТРК Украина': logobase + '0co3dwhFDhoCVeTbfMV8ASYFYxSrWM.png',
    u'ТРК Черновцы': logobase + 'ENrdPt7hypBuec07uRWhxecOTgspkN.png',
    u'ТРО Союза': logobase + 'xAXy9iMyJ4wa2wmugJvbZuDIzc9pVz.png',
    u'Трофей': logobase + 'tQTWwjNBC8aLLWiWZfCj43BhWNH51I.png',
    u'ТТС': logobase + 'crsSIipA6N288sjn4EvUyOyTd0ed9A.png',
    u'Улыбка ребенка HD': logobase + 'P8aPFN50uJWJHkrqFGb7wgzfaTHUOO.png',
    u'Унiан': logobase + 'fhpFrTDoI9xx7UlK65KAjAbdTGehLL.png',
    u'УрФО 24 HD': logobase + 'dO2b0PDb8ubcYjL4ZxLyZTQ7xjPn0q.png',
    u'Усадьба ТВ': logobase + '3PdlNOdFo973qiGewntvIRanZF6MgP.png',
    u'Успех': logobase + 'RLcfsouYRxTNrQT97AOPIYfSneJyB6.png',
    u'Фауна (Украина)': logobase + 'tuGtX9QIXM8h6O6RQoL3S0Gm7a23Zg.png',
    u'Феникс+ Кино': logobase + 'idiNkkBsxLwxWCF2VZrc9LQEevKh0d.png',
    u'Футбол': logobase + '472.png',
    u'Футбол 1 (Украина)': logobase + 'AMKtYwcgSAX5mTcPdhQDe4he18Jz7S.png',
    u'Футбол 2 (Украина)': logobase + 'PUXTI9mKcs49JnEENkh95KoKqt9VNg.png',
    u'Хабар': logobase + 'fb3YNahVC0npAJuKKEEU0x7xkGiuRT.png',
    u'Хабар 24': logobase + '5ucUtr617J0k3od3cVRn1mMy0Ezi1x.png',
    u'Хорошее кино': logobase + '9kWkXFAAlhXRtSpF3VJgVD0eMsqRZQ.png',
    u'Царьград ТВ': logobase + '9DJiua5LxhwBe2Is3l4LDJIH8zf5EE.png',
    u'Царьград ТВ HD': logobase + 'WTBbf0ZqL5Ju4AzOLum6NPC5ZGE8Tm.png',
    u'Центральный канал': logobase + 'vzfLS14qVT0rSphoNeEuO2WDvXFoub.png',
    u'ЧГТРК Грозный': logobase + 'LqDNdQj6nf4MraZztT6ZnACn7yOJpV.png',
    u'Че': logobase + 'Hv36ZG48lg1mm2wdxAo3ju1EFS41Ga.png',
    u'Че (+2)': logobase + 'HYWZATW7uW3ajRR7ULEZxcVteqHIqt.png',
    u'Че (+7)': logobase + 'fV6EjhiQaVyMMlk1era5UxYZOKX7Rf.png',
    u'Черновицкий Проминь HD': logobase + 'Us5Sr5jEx6SA6eBdZA9xchHzj1hJ4t.png',
    u'Черноморская телекомпания': logobase + 'LJVoPVcJAE0s4DNmXCga0UPZkRkLTq.png',
    u'ЧП-Инфо': logobase + 'Xy7mLl3exaBKuLlDGdrRls6hyR7mSw.png',
    u'Шансон ТВ': logobase + 'VY0TyCCkKOj5b8BhBJjT020sQoxL9F.png',
    u'Эгоист ТВ': logobase + 'moG8uExVh4nw3MN7dmGFdysJHBWLk6.png',
    u'Эко-ТВ': logobase + 'EmsE2NuqzHi5NXh6OIMMXQpfmD0VIl.png',
    u'Эфир 24 (Татарстан 24)': logobase + '8H6PLKiehQgY46uEPLIzebfSTSnwIx.png',
    u'Ю': logobase + 'YvnG7hXCwMmHnakp2KkCbqeCigHcuK.png',
    u'Ю (+2)': logobase + 'YvnG7hXCwMmHnakp2KkCbqeCigHcuK.png',
    u'Ювелирочка': logobase + 'pvKHFUCv25R51hJoUpAJfvjGnWyqoZ.png',
    u'Юмор ТВ': logobase + '6VFA1SVxeFHUsGaKPbNxWZREDkGeZw.png',
    u'Юнион': logobase + '0TgIAZbV3nAOO4OxrGGN94atKhnBS2.png',
    u'Ямал Регион': logobase + 'xapccCaMjlT6JEAkZmk27wzCXlEU2m.png'
}